% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pk}
\alias{pk}
\title{Parkinsons data from UCI machine learning archive}
\format{
A tibble with 1,013 observations and 3 variables
\describe{
\item{name}{ASCII subject name and recording number}
\item{\code{MDVP:Fo(Hz)}}{Average vocal fundamental frequency}
\item{\code{MDVP:Fhi(Hz)}}{Maximum vocal fundamental frequency}
\item{\code{MDVP:Flo(Hz)}}{Minimum vocal fundamental frequency}
\item{\code{MDVP:Jitter},\code{MDVP:Jitter(Abs)},\code{MDVP:RAP},\code{MDVP:PPQ},\code{Jitter:DDP}}{Several measures of variation in fundamental frequency}
\item{\code{MDVP:Shimmer},\code{MDVP:Shimmer(dB)},\code{Shimmer:APQ3},\code{Shimmer:APQ5},\code{MDVP:APQ},\code{Shimmer:DDA}}{Several measures of variation in amplitude}
\item{\code{NHR},\code{HNR}}{Two measures of ratio of noise to tonal components in the voice}
\item{\code{status}}{Health status of the subject (one) - Parkinson's, (zero) - healthy}
\item{\code{RPDE},\code{D2}}{Two nonlinear dynamical complexity measures}
\item{\code{DFA}}{Signal fractal scaling exponent}
\item{\code{spread1},\code{spread2},\code{PPE}}{Three nonlinear measures of fundamental frequency variation}
}
}
\description{
Biomedical voice measurements from 31 people,
23 with Parkinson's disease (PD). Each column
in the table is a particular voice measure, and
each row corresponds one of 195 voice recording
from these individuals ("name" column). The main
aim of the data is to discriminate healthy people
from those with PD, according to "status" column
which is set to 0 for healthy and 1 for PD.
}
\details{
The data is available at \href{https://archive.ics.uci.edu/ml/datasets/Parkinsons}{The UCI Machine Learning Repository}
in ASCII CSV format. The rows of the CSV file contain
an instance corresponding to one voice recording.
There are around six recordings per patient, the name
of the patient is identified in the first column.

The data are originally analysed in:
Max A. Little, Patrick E. McSharry, Eric J. Hunter, Lorraine O. Ramig (2008),
'Suitability of dysphonia measurements for telemonitoring of Parkinson's disease',
IEEE Transactions on Biomedical Engineering.
}
