% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatchedLayer.R
\name{hatchedLayer}
\alias{hatchedLayer}
\title{Hatched Layer}
\usage{
hatchedLayer(x, pattern = "dot", density = 1, txt = "a", ...)
}
\arguments{
\item{x}{an sf object, a simple feature collection. It should be either a 
\code{POLYGON} or a \code{MULTIPOLYGON}.}

\item{pattern}{Desired pattern to use for hatching. Possible values are:
\itemize{
  \item Dots: \code{"dot", "text"}
  \item Lines \code{"diamond","grid","hexagon","horizontal", "vertical",
  "zigzag","left2right","right2left","circle"}
}}

\item{density}{of the grid. By default the function uses a grid with a 
minimum of 10 cells on the shortest dimension of the bounding box. 
Additionally, it is possible to pass a 
\code{\link[sf:st_make_grid]{cellsize}} value that would feed the 
\code{\link[sf:st_make_grid]{st_make_grid}} underlying function.}

\item{txt}{for the \code{"text"} pattern, that should be a character.}

\item{...}{Additional graphic parameters (see Details).}
}
\value{
When passing \code{mode='sfc'} an 'sf' object (either MULTLINESTRING
 or MULTIPOINT) is returned.
}
\description{
Plot a hatched layer with several different patterns. Suitable 
for b/w print maps.
}
\details{
Possible values are:
\tabular{lccccccc}{
\bold{pattern}        \tab \bold{add} \tab \bold{col} \tab \bold{bg} \tab \bold{cex} \tab \bold{pch} \tab \bold{lwd} \tab \bold{lty}\cr
\bold{"dot"}          \tab x   \tab x   \tab x  \tab x   \tab x   \tab     \tab    \cr
\bold{"text"}         \tab x   \tab x   \tab    \tab x   \tab     \tab     \tab    \cr
\bold{Lines patterns} \tab x   \tab x   \tab    \tab     \tab     \tab x   \tab x  
}
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package = "cartography"))
par(mar=c(1,1,1,1))
hatchedLayer(mtq, "dot")
title("dot")
plot(st_geometry(mtq), border = NA, col="grey80")
hatchedLayer(mtq, "text", txt = "Y", add=TRUE)
title("text")
hatchedLayer(mtq, "diamond", density = 0.5)
plot(st_union(st_geometry(mtq)), add = TRUE)
title("diamond")
hatchedLayer(mtq, "grid", lwd = 1.5)
title("grid")
hatchedLayer(mtq, "hexagon", col = "blue")
title("hexagon")
hatchedLayer(mtq, "horizontal", lty = 5)
title("horizontal")
hatchedLayer(mtq, "vertical")
title("vertical")
hatchedLayer(mtq, "left2right")
title("left2right")
hatchedLayer(mtq, "right2left")
title("right2left")
hatchedLayer(mtq, "zigzag",cellsize=5000)
title("zigzag")
hatchedLayer(mtq, "circle")
title("circle")
}
\seealso{
\link{legendHatched}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
