% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arml.R
\name{forecast.ARml}
\alias{forecast.ARml}
\title{Forecasting an ARml object}
\usage{
\method{forecast}{ARml}(
  object,
  h = frequency(object$y),
  xreg = NULL,
  level = c(80, 95),
  PI = FALSE,
  num_bs = 1000,
  ...
)
}
\arguments{
\item{object}{A list class of ARml}

\item{h}{forecast horizon}

\item{xreg}{Optionally, a numerical vector or matrix of future external
regressors}

\item{level}{Confidence level for prediction intervals.}

\item{PI}{If TRUE, prediction intervals are produced, otherwise only point
forecasts are calculated. If PI is FALSE, then level, fan, bootstrap and
npaths are all ignored.}

\item{num_bs}{Number of bootstrapped versions to generate.}

\item{...}{Other arguments pased to forecast::forecast()}
}
\value{
A list class of forecast containing the following elemets
\itemize{
\item x : The input time series
\item method : The name of the forecasting method as a character string
\item mean : Point forecasts as a time series
\item lower : Lower limits for prediction intervals
\item upper : Upper limits for prediction intervals
\item level : The confidence values associated with the prediction intervals
\item model : A list containing information about the fitted model
\item newxreg : A matrix containing regressors
}
}
\description{
Forecasting an ARml object
}
\examples{

library(caretForecast)

train_data <- window(AirPassengers, end = c(1959, 12))

test <- window(AirPassengers, start = c(1960, 1))

ARml(train_data, caret_method = "lm", max_lag = 12) -> fit

forecast(fit, h = length(test), level = c(80,95), PI = TRUE) -> fc

autoplot(fc)+ autolayer(test)

accuracy(fc, test)

}
\author{
Resul Akay
}
