% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretStack.R
\name{predict.caretStack}
\alias{predict.caretStack}
\title{Make predictions from a caretStack}
\usage{
\method{predict}{caretStack}(object, newdata = NULL, se = FALSE,
  level = 0.95, return_weights = FALSE, ...)
}
\arguments{
\item{object}{a  \code{\link{caretStack}} to make predictions from.}

\item{newdata}{a new dataframe to make predictions on}

\item{se}{logical, should prediction errors be produced? Default is false.}

\item{level}{tolerance/confidence level}

\item{return_weights}{a logical indicating whether prediction weights for each model
should be returned}

\item{...}{arguments to pass to \code{\link{predict.train}}.}
}
\description{
Make predictions from a caretStack. This function passes the data to each function in
turn to make a matrix of predictions, and then multiplies that matrix by the vector of
weights to get a single, combined vector of predictions.
}
\details{
Prediction weights are defined as variable importance in the stacked
caret model. This is not available for all cases such as where the library
model predictions are transformed before being passed to the stacking model.
}
\examples{
\dontrun{
library("rpart")
models <- caretList(
  x=iris[1:100,1:2],
  y=iris[1:100,3],
  trControl=trainControl(method="cv"),
  methodList=c("rpart", "glm")
)
meta_model <- caretStack(models, method="lm")
RMSE(predict(meta_model, iris[101:150,1:2]), iris[101:150,3])
}
}

