% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_and_co2.R
\name{fuel_cons_forwarder_2}
\alias{fuel_cons_forwarder_2}
\title{Fuel Consumption of a Forwarder per Cubic Meter Harvested Wood (Version #2)}
\usage{
fuel_cons_forwarder_2(aed, harvest_vol_ha, mineral_soil = TRUE)
}
\arguments{
\item{aed}{Average extraction distance to the nearest truck road}

\item{harvest_vol_ha}{Harvested merchandable wood volume over bark per ha
(m³/ha)}

\item{mineral_soil}{Logical, TRUE (default) if the operation takes place on
mineral soil, FALSE if not}
}
\value{
Fuel consumption of a forwarder in liters diesel fuel per m³ wood to
be handled
}
\description{
Fuel consumption per m³ harvested wood after
\insertCite{karha_et_al_2023;textual}{care4cmodel}. Includes loading,
transportation, and unloading.
}
\examples{
  frd <- c(15, 30, 60, 100) # Forest road densities m/ha
  aed <- avg_extraction_distance(frd)

  fuel_cons_forwarder_2(aed, 100, TRUE)
  fuel_cons_forwarder_2(aed, 100, FALSE)

}
\references{
\insertRef{karha_et_al_2023}{care4cmodel}
}
