% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear.R
\name{sine_curve}
\alias{sine_curve}
\title{Generate Sine Curve Data with Noise}
\usage{
sine_curve(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the sine curve data with noise.
}
\description{
This function generates a dataset representing a sine curve with added noise.
}
\examples{
set.seed(20240412)
sine_curve <- sine_curve(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
}
