% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variant_influences.R
\name{plot_variant_influences}
\alias{plot_variant_influences}
\title{Plot cape coefficients}
\usage{
plot_variant_influences(
  data_obj,
  p_or_q = 0.05,
  min_std_effect = 0,
  plot_all_vals = FALSE,
  standardize = FALSE,
  color_scheme = c("DO/CC", "other"),
  pos_col = "brown",
  neg_col = "blue",
  not_tested_col = "lightgray",
  show_marker_labels = FALSE,
  show_chr = TRUE,
  label_chr = TRUE,
  show_alleles = TRUE,
  scale_effects = c("log10", "sqrt", "none"),
  pheno_width = NULL,
  covar_width = NULL,
  covar_labels = NULL,
  phenotype_labels = NULL,
  show_not_tested = TRUE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{p_or_q}{A threshold indicating the maximum p value (or q value
if FDR was used) of significant interactions and main effects}

\item{min_std_effect}{An optional filter. The plot will exclude
all pairs with standardized effects below the number set here.}

\item{plot_all_vals}{If TRUE will plot all values regardless of 
significant}

\item{standardize}{Whether to plot effect sizes (FALSE) or standardized
effect sizes (TRUE)}

\item{color_scheme}{A character value of either "DO/CC" or other indicating the 
color scheme of main effects. If "DO/CC" allele effects can be plotted with the
DO/CC colors.}

\item{pos_col}{The color to use for positive main effects and interactions
must be one of "green", "purple", "red", "orange", "blue", "brown", "yellow", "gray"
see \code{\link{get_color}}}

\item{neg_col}{The color to use for negative main effects and interactions
takes the same values as pos_col.}

\item{not_tested_col}{The color to use for marker pairs not tested. Takes
the same values as pos_col and neg_col}

\item{show_marker_labels}{Whether to write the marker labels on the plot}

\item{show_chr}{Whether to show chromosome boundaries}

\item{label_chr}{Whether to label chromosomes if plotted}

\item{show_alleles}{If TRUE, the allele of each marker is indicated by color.}

\item{scale_effects}{One of "log10", "sqrt", "none." If some effects are
very large, scaling them can help show contrasts between smaller values.
The default is no scaling.}

\item{pheno_width}{Each marker and trait gets one column in the matrix. 
If there are many markers, this makes the effects on the traits difficult 
to see. pheno_width increases the number of columns given to the phenotypes.
For example, if pheno_width = 11, the phenotypes will be shown 11 times wider
than individual markers.}

\item{covar_width}{See pheno_width. This is the same effect for covariates.}

\item{covar_labels}{Labels for covariates if different from those stored in 
the data object.}

\item{phenotype_labels}{Labels for traits if different from those stored in 
the data object}

\item{show_not_tested}{Whether to color the marker pairs that were not
tested. If FALSE, they will not be colored in.}
}
\value{
This function invisibly returns the variant influences matrix.
shown in the heat map.
}
\description{
This function plots the the cape coefficients between
pairs of markers as a heat map.
The interactions are shown in the main part of the heatmap
while the main effects are shown on the right hand side.
Directed interactions are read from the y axis to the x axis.
For example an interaction from marker1 to marker2 will be shown
in the row corresponding to marker1 and the column corresponding
to marker2. 
Similarly, if marker1 has a main effect on any traits, these
will be shown in the row for marker1 and the trait columns.
}
