% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media.R
\name{media}
\alias{media}
\alias{media<-}
\title{Get or set media}
\usage{
media(x)

media(x) <- value
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by
\code{read_camtrapdp()}.}

\item{value}{A data frame to assign as media.}
}
\value{
\code{\link[=tibble]{tibble()}} data frame with media.
}
\description{
\code{media()} gets the media from a Camera Trap Data Package object.

\verb{media<-()} is the assignment equivalent.
It should only be used within other functions, where the expected data
structure can be guaranteed.
}
\examples{
x <- example_dataset()
# Get media
media(x)

# Set media (not recommended outside a function)
media(x) <- head(media(x), 1)
}
\seealso{
Other accessor functions: 
\code{\link{deployments}()},
\code{\link{events}()},
\code{\link{locations}()},
\code{\link{observations}()},
\code{\link{taxa}()}
}
\concept{accessor functions}
