% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbrev-full.R
\name{abbrev_state}
\alias{abbrev_state}
\title{Abbreviate US state names}
\usage{
abbrev_state(full)
}
\arguments{
\item{full}{A full US state name character vector (e.g., "Vermont").}
}
\value{
The 2-letter USPS abbreviation of for state names (e.g., "VT").
}
\description{
This function is used to first normalize a \code{full} state name and then call
\code{\link[=abbrev_full]{abbrev_full()}} using \link{valid_name} and \link{valid_state} as the \code{full} and \code{rep}
arguments.
}
\examples{
abbrev_state(full = state.name)
abbrev_state(full = c("new mexico", "france"))
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
