% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_humidity.R
\name{relative_humidity}
\alias{relative_humidity}
\title{relative_humidity}
\usage{
relative_humidity(t2m, d2m, unit = "Celsius", method = "August-Roche-Magnus")
}
\arguments{
\item{t2m}{2m temperature (in Celsius)}

\item{d2m}{2m dew point temperature (in Celsius)}

\item{unit}{can be "Celsius" (default) or "Kelvin"}

\item{method}{can be "August-Roche-Magnus" (default) or "Clausius-Clapeyron"}
}
\value{
The function returns a numeric, with length equal to t2m (and d2m).
}
\description{
Calculate relative humidity from 2m temperature (in Celsius) and
2m dew point temperature (in Celsius).
}
\examples{
\dontrun{
  relative_humidity(t2m = 30, d2m = 25,
                    unit = "Celsius",
                    method = "August-Roche-Magnus")
}

}
