% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calACS.R
\name{calACSStrict}
\alias{calACSStrict}
\title{Calculate the total number of all common subsequences between a string and a vector/list of strings
Subsequences cannot be interrupted by any item, i.e. q-w is not a subsequence of q-w-e-r and q-e-w-r due to the interrupting 'e' in the second sequence}
\usage{
calACSStrict(vecA, listB, sep = "-", dropFirstItem = FALSE)
}
\arguments{
\item{vecA}{The single string}

\item{listB}{The vector/list of 1 or more strings}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}
}
\value{
The total number of all common subsequences as an integer in a vector
}
\description{
Calculate the total number of all common subsequences between a string and a vector/list of strings
Subsequences cannot be interrupted by any item, i.e. q-w is not a subsequence of q-w-e-r and q-e-w-r due to the interrupting 'e' in the second sequence
}
\examples{
calACSStrict("q-w-e-r", c("q-e-w-r","q-r-e-w"), "-")
calACSStrict("itemToBeDropped-q-w-e-r", "itemToBeDroped-q-e-w-r", "-", dropFirstItem=TRUE)

}

