% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-mc-phi.R
\name{MCPhi}
\alias{MCPhi}
\title{Generate Random Drift Matrices
Using the Monte Carlo Method}
\usage{
MCPhi(phi, vcov_phi_vec, R, test_phi = TRUE, ncores = NULL, seed = NULL)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{vcov_phi_vec}{Numeric matrix.
The sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.}

\item{R}{Positive integer.
Number of replications.}

\item{test_phi}{Logical.
If \code{test_phi = TRUE},
the function tests the stability
of the generated drift matrix \eqn{\boldsymbol{\Phi}}.
If the test returns \code{FALSE},
the function generates a new drift matrix \eqn{\boldsymbol{\Phi}}
and runs the test recursively
until the test returns \code{TRUE}.}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL},
use a single core.
Consider using multiple cores
when number of replications \code{R}
is a large value.}

\item{seed}{Random seed.}
}
\value{
Returns an object
of class \code{ctmedmc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("MCPhi").}
\item{output}{A list simulated drift matrices.}
}
}
\description{
This function generates random
drift matrices \eqn{\boldsymbol{\Phi}}
using the Monte Carlo method.
}
\details{
\subsection{Monte Carlo Method}{

Let \eqn{\boldsymbol{\theta}} be
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)},
that is,
the elements of the \eqn{\boldsymbol{\Phi}} matrix
in vector form sorted column-wise.
Let \eqn{\hat{\boldsymbol{\theta}}} be
\eqn{\mathrm{vec} \left( \hat{\boldsymbol{\Phi}} \right)}.
Based on the asymptotic properties of maximum likelihood estimators,
we can assume that estimators are normally distributed
around the population parameters.
\deqn{
  	\hat{\boldsymbol{\theta}}
  	\sim
  	\mathcal{N}
  	\left(
  	\boldsymbol{\theta},
  	\mathbb{V} \left( \hat{\boldsymbol{\theta}} \right)
  	\right)
  }
Using this distributional assumption,
a sampling distribution of \eqn{\hat{\boldsymbol{\theta}}}
which we refer to as \eqn{\hat{\boldsymbol{\theta}}^{\ast}}
can be generated by replacing the population parameters
with sample estimates,
that is,
\deqn{
  	\hat{\boldsymbol{\theta}}^{\ast}
  	\sim
  	\mathcal{N}
  	\left(
  	\hat{\boldsymbol{\theta}},
  	\hat{\mathbb{V}} \left( \hat{\boldsymbol{\theta}} \right)
  	\right) .
  }
}
}
\examples{
set.seed(42)
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
MCPhi(
  phi = phi,
  vcov_phi_vec = 0.1 * diag(9),
  R = 100L # use a large value for R in actual research
)
phi <- matrix(
  data = c(
    -6, 5.5, 0, 0,
    1.25, -2.5, 5.9, -7.3,
    0, 0, -6, 2.5,
    5, 0, 0, -6
  ),
  nrow = 4
)
colnames(phi) <- rownames(phi) <- paste0("y", 1:4)
MCPhi(
  phi = phi,
  vcov_phi_vec = 0.1 * diag(16),
  R = 100L, # use a large value for R in actual research
  test_phi = FALSE
)

}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{DeltaBeta}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{MCBeta}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorPhi}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{mc}
