% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{axe-coxph}
\alias{axe-coxph}
\alias{axe_env.coxph}
\alias{axe_data.coxph}
\title{Axing a coxph.}
\usage{
\method{axe_env}{coxph}(x, verbose = FALSE, ...)

\method{axe_data}{coxph}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed coxph object.
}
\description{
Axing a coxph.
}
\examples{
\dontshow{if (rlang::is_installed("survival")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

example_data <-
  tibble::tibble(
    time = rpois(1000, 2) + 1,
    status = rbinom(1000, 1, .5),
    x = rpois(1000, .5),
    covar = rbinom(1000, 1, .5)
  )

example_data

make_big_model <- function() {
  boop <- runif(1e6)
  coxph(Surv(time, status) ~ x + strata(covar), example_data)
}

res <- make_big_model()

weigh(res)
weigh(butcher(res))
\dontshow{\}) # examplesIf}
}
