% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclass.R
\name{axe-sclass}
\alias{axe-sclass}
\alias{axe_call.sclass}
\alias{axe_env.sclass}
\title{Axing a sclass object.}
\usage{
\method{axe_call}{sclass}(x, verbose = FALSE, ...)

\method{axe_env}{sclass}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed sclass object.
}
\description{
sclass objects are byproducts of classbagg objects.
}
\examples{
# Load libraries
suppressWarnings(suppressMessages(library(ipred)))
suppressWarnings(suppressMessages(library(rpart)))
suppressWarnings(suppressMessages(library(MASS)))

# Load data
data("GlaucomaM", package = "TH.data")

classbagg_fit <- bagging(Class ~ ., data = GlaucomaM, coob = TRUE)

out <- butcher(classbagg_fit$mtrees[[1]], verbose = TRUE)

# Another classbagg object
wrapped_classbagg <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- bagging(Species ~ .,
                 data = iris,
                 nbagg = 10,
                 coob = TRUE)
  return(fit)
}

# Remove junk
cleaned_classbagg <- butcher(wrapped_classbagg(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_classbagg)

}
