% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{converged}
\alias{converged}
\title{Test a model for convergence}
\usage{
converged(model, singular.ok = FALSE)
}
\arguments{
\item{model}{The model object to test.}

\item{singular.ok}{A logical indicating whether singular fits are accepted as `converged' or not. Relevant only for lme4 models.}
}
\value{
Logical indicating whether the model converged.
}
\description{
Test a model for convergence
}
\examples{
library(buildmer)
library(lme4)
good1 <- lm(Reaction ~ Days,sleepstudy)
good2 <- lmer(Reaction ~ Days + (Days|Subject),sleepstudy)
bad <- lmer(Reaction ~ Days + (Days|Subject),sleepstudy,control=lmerControl(
            optimizer='bobyqa',optCtrl=list(maxfun=1)))
sapply(list(good1,good2,bad),converged)
}
