% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.mcmc_output.R
\name{as.data.frame.mcmc_output}
\alias{as.data.frame.mcmc_output}
\title{Convert MCMC chain to data.frame}
\usage{
\method{as.data.frame}{mcmc_output}(
  x,
  row.names,
  optional,
  variable = c("theta", "states"),
  times,
  states,
  expand = !(x$mcmc_type \%in\% paste0("is", 1:3)),
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{run_mcmc}}.}

\item{row.names}{Ignored.}

\item{optional}{Ignored.}

\item{variable}{Return samples of \code{"theta"} (default) or \code{"states"}?}

\item{times}{Vector of indices. In case of states, what time points to expand? Default is all.}

\item{states}{Vector of indices. In case of states, what states to expand? Default is all.}

\item{expand}{Should the jump-chain be expanded? 
Defaults to \code{TRUE} for non-IS-MCMC, and \code{FALSE} for IS-MCMC. 
For \code{expand = FALSE} and always for IS-MCMC, 
the resulting data.frame contains variable weight (= counts times IS-weights).}

\item{...}{Ignored.}
}
\description{
Converts the MCMC chain output of \code{\link{run_mcmc}} to data.frame.
}
