% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-dependencies.R
\name{bs_dependency}
\alias{bs_dependency}
\alias{bs_dependency_defer}
\title{Themeable HTML components}
\usage{
bs_dependency(
  input = list(),
  theme,
  name,
  version,
  cache_key_extra = NULL,
  .dep_args = list(),
  .sass_args = list()
)

bs_dependency_defer(func)
}
\arguments{
\item{input}{Sass rules to compile, using \code{theme}.}

\item{theme}{A \code{\link[=bs_theme]{bs_theme()}} object.}

\item{name}{Library name}

\item{version}{Library version}

\item{cache_key_extra}{Extra information to add to the sass cache key. It is
useful to add the version of your package.}

\item{.dep_args}{A list of additional arguments to pass to
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}. Note that \code{package} has no effect and
\code{script} must be absolute path(s).}

\item{.sass_args}{A list of additional arguments to pass to
\code{\link[sass:sass_partial]{sass::sass_partial()}}.}

\item{func}{a \emph{non-anonymous} function, with a \emph{single} argument. This function
should accept a \code{\link[=bs_theme]{bs_theme()}} object and return a single \code{\link[=htmlDependency]{htmlDependency()}},
a list of them, or \code{NULL}.}
}
\value{
\code{bs_dependency()} returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} and
\code{bs_dependency_defer()} returns an \code{\link[htmltools:tagFunction]{htmltools::tagFunction()}}
}
\description{
Themeable HTML components use Sass to generate CSS rules from Bootstrap Sass
variables, functions, and/or mixins (i.e., stuff inside of \code{theme}).
\code{bs_dependencies()} makes it a bit easier to create themeable components by
compiling \code{\link[sass:sass]{sass::sass()}} (\code{input}) together with Bootstrap Sass inside of a
\code{theme}, and packaging up the result into an \code{\link[=htmlDependency]{htmlDependency()}}.

Themable components can also be  \emph{dynamically} themed inside of Shiny (i.e.,
they may be themed in 'real-time' via \code{\link[=bs_themer]{bs_themer()}}, and more generally,
update their styles in response to \link[shiny:session]{shiny::session}'s \code{setCurrentTheme()}
method). Dynamically themeable components provide a "recipe" (i.e., a
function) to \code{bs_dependency_defer()}, describing how to generate new CSS
stylesheet(s) from a new \code{theme}. This function is called when the HTML page
is first rendered, and may be invoked again with a new \code{theme} whenever
\link[shiny:session]{shiny::session}'s \code{setCurrentTheme()} is called.
}
\examples{

\dontrun{

myWidgetVersion <- "1.2.3"

myWidgetDependency <- function() {
  list(
    bs_dependency_defer(myWidgetCss),
    htmlDependency(
      name = "mywidget-js",
      version = myWidgetVersion,
      src = system.file(package = "mypackage", "js"),
      script = "mywidget.js"
    )
  )
}

myWidgetCSS <- function(theme) {
  if (!is_bs_theme(theme)) {
    return(
      htmlDependency(
        name = "mywidget-css",
        version = myWidgetVersion,
        src = system.file(package = "mypackage", "css"),
        stylesheet = "mywidget.css"
      )
    )
  }

  # Compile mywidget.scss using the variables and defaults from the theme
  # object.
  sass_input <- sass::sass_file(system.file(package = "mypackage", "scss/mywidget.scss"))

  bs_dependency(
    input = sass_input,
    theme = theme,
    name = "mywidget",
    version = myWidgetVersion,
    cache_key_extra = utils::packageVersion("mypackage")
  )
}

# Note that myWidgetDependency is not defined inside of myWidget. This is so
# that, if `myWidget()` is called multiple times, Shiny can tell that the
# function objects are identical and deduplicate them.
myWidget <- function(id) {
  div(
    id = id,
    span("myWidget"),
    myWidgetDependency()
  )
}
}

}
\references{
\url{https://rstudio.github.io/bslib/articles/custom-components.html}
}
