% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_follow_suggestions.R
\name{bs_get_follow_suggestions}
\alias{bs_get_follow_suggestions}
\title{Get suggested follows related to a given actor}
\usage{
bs_get_follow_suggestions(
  actor,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{actor}{Character, length 1. name of 1 actor, such as \code{'chriskenny.bsky.social'}}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of actors
}
\description{
Get suggested follows related to a given actor
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getSuggestedFollowsByActor.json}{graph/getSuggestedFollowsByActor.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_follow_suggestions('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{graph}
