% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_nav}
\alias{bs_nav}
\title{Create a Bootstrap nav}
\usage{
bs_nav(
  items = list(),
  vertical = FALSE,
  tabs = FALSE,
  pills = FALSE,
  fill = FALSE,
  justified = FALSE,
  nav_class = "nav",
  background_class = NULL,
  text_class = NULL,
  background_color = NULL,
  ul_class = "nav",
  li_class = "nav-item",
  a_class = "nav-link"
)
}
\arguments{
\item{items}{A list, creates nav elements. If a list item is named, names should be links
and values should be text to display in the nav for that link. Names will be passed to the
href param and values to the main content of the html5::a() function which will be wrapped by the html5::li() function,
each of which have Bootstrap classes added by default.If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually. For example, to add a drop-down, add an unnamed item to the list
with HTML defining the drop-down as the value of the item.}

\item{vertical}{TRUE/FALSE, if TRUE,}

\item{tabs}{TRUE/FALSE, if TRUE,}

\item{pills}{TRUE/FALSE, if TRUE,}

\item{fill}{TRUE/FALSE, if TRUE,}

\item{justified}{TRUE/FALSE, if TRUE,}

\item{nav_class}{A string, default class used for the "nav" tag wrapping the nav elements.}

\item{background_class}{A string, a Bootstrap background class such as "bg-primary" that gets appended to nav_class.}

\item{text_class}{A string, a Bootstrap text class such as "navbar-dark" that gets appended to nav_class.}

\item{background_color}{A string, a CSS color (ex. "#00FFFF"). Background-class will overrule this, so setting background_class to NULL
will ensure the background color is applied.}

\item{ul_class}{A string, default class used for the "ul" tag wrapping the nav elements.}

\item{li_class}{A string, default class used for the "li" tags wrapping the nav elements if the input list item is named.}

\item{a_class}{A string, default class used for the "a" tags wrapping the nav elements if the input list item is named.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap nav
}
\examples{
bs_nav(
items = list(
  "#" = "Option 1",
  "#" = "Option 2",
  "#" = "Option 3"
)
)
}
