% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Alert}
\alias{bs4Alert}
\title{Create a Bootstrap 4 alert}
\usage{
bs4Alert(..., title, closable = TRUE, width = 6, elevation = NULL,
  status = c("primary", "warning", "danger", "info", "success"))
}
\arguments{
\item{...}{Alert content.}

\item{title}{Alert title.}

\item{closable}{Whether to allow the user to close the alert. FALSE by default.}

\item{width}{Alert width. Between 1 and 12.}

\item{elevation}{Alert elevation.}

\item{status}{Alert status. "primary", "success", "warning", "danger" or "info".}
}
\description{
AdminLTE3 alert
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
       title = "Alerts",
       bs4Alert(
        title = "Be Careful!",
        status = "danger",
        closable = FALSE,
        "Danger alert preview. This alert is not dismissable. 
        A wonderful serenity has taken possession of my entire soul, 
        like these sweet mornings of spring which 
        I enjoy with my whole heart."
       ),
       bs4Alert(
        title = "Congratulation!",
        status = "success",
        closable = TRUE,
        elevation = 4,
        "Warning alert preview. This alert is dismissable. 
        A wonderful serenity has taken possession of my entire soul, 
        like these sweet mornings of spring which 
        I enjoy with my whole heart."
       )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
