% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{GLM_summary}
\alias{GLM_summary}
\title{Tidy report of GLM (\code{lm} and \code{glm} models).}
\usage{
GLM_summary(
  model,
  robust = FALSE,
  cluster = NULL,
  digits = 3,
  nsmall = digits,
  ...
)
}
\arguments{
\item{model}{A model fitted with \code{lm} or \code{glm} function.}

\item{robust}{[Only for \code{lm} and \code{glm}]
\code{FALSE} (default), \code{TRUE} (then the default is \code{"HC1"}),
\code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, or \code{"HC5"}.
It will add a table with heteroskedasticity-robust standard errors (aka. Huber-White standard errors).
For details, see \code{?sandwich::vcovHC} and \code{?jtools::summ.lm}.

*** \code{"HC1"} is the default of Stata, whereas \code{"HC3"} is the default suggested by the \code{sandwich} package.}

\item{cluster}{[Only for \code{lm} and \code{glm}]
Cluster-robust standard errors are computed if cluster is set to the name of the input data's cluster variable or is a vector of clusters.}

\item{digits, nsmall}{Number of decimal places of output. Default is 3.}

\item{...}{Other arguments. You may re-define \code{formula}, \code{data}, or \code{family}.}
}
\value{
No return value.
}
\description{
NOTE: \code{\link{model_summary}} is preferred.
}
\examples{
## Example 1: OLS regression
lm = lm(Temp ~ Month + Day + Wind + Solar.R, data=airquality)
GLM_summary(lm)
GLM_summary(lm, robust="HC1")
# Stata's default is "HC1"
# R package <sandwich>'s default is "HC3"

## Example 2: Logistic regression
glm = glm(case ~ age + parity + education + spontaneous + induced,
          data=infert, family=binomial)
GLM_summary(glm)
GLM_summary(glm, robust="HC1", cluster="stratum")

}
\seealso{
\code{\link{print_table}} (print simple table)

\code{\link{model_summary}} (highly suggested)

\code{\link{HLM_summary}}

\code{\link{regress}}
}
