% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_01_basic.R
\name{Corr}
\alias{Corr}
\title{Correlation analysis.}
\usage{
Corr(
  data,
  method = "pearson",
  p.adjust = "none",
  all.as.numeric = TRUE,
  digits = 2,
  nsmall = digits,
  file = NULL,
  plot = TRUE,
  plot.range = c(-1, 1),
  plot.palette = NULL,
  plot.color.levels = 201,
  plot.file = NULL,
  plot.width = 8,
  plot.height = 6,
  plot.dpi = 500
)
}
\arguments{
\item{data}{Data frame.}

\item{method}{\code{"pearson"} (default), \code{"spearman"}, or \code{"kendall"}.}

\item{p.adjust}{Adjustment of \emph{p} values for multiple tests:
\code{"none"}, \code{"fdr"}, \code{"holm"}, \code{"bonferroni"}, ...
For details, see \code{\link[stats:p.adjust]{stats::p.adjust()}}.}

\item{all.as.numeric}{\code{TRUE} (default) or \code{FALSE}.
Transform all variables into numeric (continuous).}

\item{digits, nsmall}{Number of decimal places of output. Default is \code{2}.}

\item{file}{File name of MS Word (\code{.doc}).}

\item{plot}{\code{TRUE} (default) or \code{FALSE}. Plot the correlation matrix.}

\item{plot.range}{Range of correlation coefficients for plot. Default is \code{c(-1, 1)}.}

\item{plot.palette}{Color gradient for plot. Default is \code{c("#B52127", "white", "#2171B5")}.
You may also set it to, e.g., \code{c("red", "white", "blue")}.}

\item{plot.color.levels}{Default is \code{201}.}

\item{plot.file}{\code{NULL} (default, plot in RStudio) or a file name (\code{"xxx.png"}).}

\item{plot.width}{Width (in "inch") of the saved plot. Default is \code{8}.}

\item{plot.height}{Height (in "inch") of the saved plot. Default is \code{6}.}

\item{plot.dpi}{DPI (dots per inch) of the saved plot. Default is \code{500}.}
}
\value{
Invisibly return the correlation results obtained from
\code{\link[psych:corr.test]{psych::corr.test()}}.
}
\description{
Correlation analysis.
}
\examples{
Corr(airquality)
Corr(airquality, p.adjust="bonferroni")

d = as.data.table(psych::bfi)
d[, `:=`(
  gender = as.factor(gender),
  education = as.factor(education),
  E = MEAN(d, "E", 1:5, rev=c(1,2), likert=1:6),
  A = MEAN(d, "A", 1:5, rev=1, likert=1:6),
  C = MEAN(d, "C", 1:5, rev=c(4,5), likert=1:6),
  N = MEAN(d, "N", 1:5, likert=1:6),
  O = MEAN(d, "O", 1:5, rev=c(2,5), likert=1:6)
)]
Corr(d[, .(age, gender, education, E, A, C, N, O)])

}
\seealso{
\code{\link{Describe}}
}
