% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomatic_names.R
\name{phylomatic_names}
\alias{phylomatic_names}
\title{Phylomatic names}
\usage{
phylomatic_names(taxa, format = "isubmit", db = "ncbi", ...)
}
\arguments{
\item{taxa}{quoted tsn number (taxonomic serial number)}

\item{format}{output format, isubmit (you can paste in to the Phylomatic
website), or 'rsubmit' to use in fxn phylomatic_tree}

\item{db}{One of "ncbi", "itis", or "apg". if you use "apg", no HTTP
requests are made (no internet connection needed), whereas if you use
"ncbi" or "itis" you do need an internet connection. IMPORTANT:
see \strong{Authentication} below if using "ncbi".}

\item{...}{curl options passed on to \code{\link[taxize:tax_name]{taxize::tax_name()}}}
}
\value{
string (e.g., "pinaceae/pinus/pinus_contorta"), in Phylomatic
submission format
}
\description{
Get family names to make Phylomatic input object, and
output input string to Phylomatic for use in the function phylomatic
}
\section{Authentication}{

NCBI Entrez doesn't require that you use an API key, but you get
higher rate limit with a key, from 3 to 10 requests per second, so do
get one. Run \code{\link[taxize:use_entrez]{taxize::use_entrez()}} or see
https://ncbiinsights.ncbi.nlm.nih.gov/2017/11/02/new-api-keys-for-the-e-utilities/
for instructions.

NCBI API key handling logic is done inside of the \code{taxize} package, used
inside this function.

Save your API key with the name \code{ENTREZ_KEY} as an R option in your
\code{.Rprofile} file, or as environment variables in either your \code{.Renviron}
file or \code{.bash_profile} file, or \code{.zshrc} file (if you use oh-my-zsh) or
similar. See \link{Startup} for help on R options and environment
variables. You cannot pass in your API key in this function.

Remember to restart your R session (and to start a new shell window/tab
if you're using the shell) to take advantage of the new R options
or environment variables.

We strongly recommend using environment variables over R options.
}

\examples{
\dontrun{
mynames <- c("Poa annua", "Salix goodingii", "Helianthus annuus")
phylomatic_names(taxa = mynames, format='rsubmit')
phylomatic_names(mynames, format='rsubmit', db="apg")
phylomatic_names(mynames, format='isubmit', db="ncbi")
phylomatic_names(mynames, format='isubmit', db="apg")
}
}
