% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingroup-tidiers.R
\name{tidy.binDesign}
\alias{tidy.binDesign}
\alias{bindesign_tidiers}
\title{Tidy a(n) binDesign object}
\usage{
\method{tidy}{binDesign}(x, ...)
}
\arguments{
\item{x}{A \code{\link[binGroup:binDesign]{binGroup::binDesign()}} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("binGroup", quietly = TRUE)) {

library(binGroup)
des <- binDesign(
  nmax = 300, delta = 0.06,
  p.hyp = 0.1, power = .8
)

glance(des)
tidy(des)

# the ggplot2 equivalent of plot(des)
library(ggplot2)
ggplot(tidy(des), aes(n, power)) +
  geom_line()
  
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[binGroup:binDesign]{binGroup::binDesign()}}

Other bingroup tidiers: 
\code{\link{glance.binDesign}()},
\code{\link{tidy.binWidth}()}
}
\concept{bingroup tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{n}{Number of trials in given iteration.}
  \item{power}{Power achieved for given value of n.}

}
