% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caret-tidiers.R
\name{tidy.confusionMatrix}
\alias{tidy.confusionMatrix}
\alias{caret_tidiers}
\alias{confusionMatrix_tidiers}
\title{Tidy a(n) confusionMatrix object}
\usage{
\method{tidy}{confusionMatrix}(x, by_class = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{confusionMatrix} created by a call to
\code{\link[caret:confusionMatrix]{caret::confusionMatrix()}}.}

\item{by_class}{Logical indicating whether or not to show performance
measures broken down by class. Defaults to \code{TRUE}. When \code{by_class = FALSE}
only returns a tibble with accuracy and kappa statistics.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one or more of the following columns:
\item{term}{The name of a statistic from the confusion matrix}
\item{class}{Which class the term is a measurement of}
\item{estimate}{The value of the statistic}
\item{conf.low}{Low end of 95 percent CI only applicable to accuracy}
\item{conf.high}{High end of 95 percent CI only applicable to accuracy}
\item{p.value}{P-value for accuracy and kappa statistics}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("caret", quietly = TRUE)) {

  set.seed(27)
  
  two_class_sample1 <- as.factor(sample(letters[1:2], 100, TRUE))
  two_class_sample2 <- as.factor(sample(letters[1:2], 100, TRUE))
  
  two_class_cm <- caret::confusionMatrix(
    two_class_sample1,
    two_class_sample2
  )
  
  tidy(two_class_cm)
  tidy(two_class_cm, by_class = FALSE)
  
  # multiclass example
  
  six_class_sample1 <- as.factor(sample(letters[1:6], 100, TRUE))
  six_class_sample2 <- as.factor(sample(letters[1:6], 100, TRUE))
  
  six_class_cm <- caret::confusionMatrix(
    six_class_sample1,
    six_class_sample2
  )
  
  tidy(six_class_cm)
  tidy(six_class_cm, by_class = FALSE)
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[caret:confusionMatrix]{caret::confusionMatrix()}}
}
