% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plm_tidiers.R
\name{plm_tidiers}
\alias{augment.plm}
\alias{glance.plm}
\alias{plm_tidiers}
\alias{tidy.plm}
\title{Tidiers for panel regression linear models}
\usage{
\method{tidy}{plm}(x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = FALSE, ...)

\method{augment}{plm}(x, data = as.data.frame(stats::model.frame(x)), ...)

\method{glance}{plm}(x, ...)
}
\arguments{
\item{x}{a "plm" object representing a panel object}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals}

\item{...}{extra arguments, not used}

\item{data}{original dataset}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.plm} returns a data frame with one row per
coefficient, of the same form as \code{\link{tidy.lm}}.

\code{augment} returns a data frame with one row for each
initial observation, adding the columns
  \item{.fitted}{predicted (fitted) values}
  \item{.resid}{residuals}

\code{glance} returns a one-row data frame with columns
  \item{r.squared}{The percent of variance explained by the model}
  \item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
  \item{statistic}{F-statistic}
  \item{p.value}{p-value from the F test, describing whether the full
  regression is significant}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
Tidiers for panel regression linear models
}
\examples{
if (require("plm", quietly = TRUE)) {
    data("Produc", package = "plm")
    zz <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
              data = Produc, index = c("state","year"))

    summary(zz)

    tidy(zz)
    tidy(zz, conf.int = TRUE)
    tidy(zz, conf.int = TRUE, conf.level = .9)

    head(augment(zz))

    glance(zz)
}
}
\seealso{
\code{\link{lm_tidiers}}
}

