% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.R
\name{confint_tidy}
\alias{confint_tidy}
\title{Calculate confidence interval as a tidy data frame}
\usage{
confint_tidy(x, conf.level = 0.95, func = stats::confint, ...)
}
\arguments{
\item{x}{a model object for which \code{\link{confint}} can be calculated}

\item{conf.level}{confidence level}

\item{func}{Function to use for computing confint}

\item{...}{extra arguments passed on to \code{confint}}
}
\value{
A data frame with two columns: \code{conf.low} and \code{conf.high}.
}
\description{
Return a confidence interval as a tidy data frame. This directly wraps the
\code{\link{confint}} function, but ensures it folllows broom conventions:
column names of \code{conf.low} and \code{conf.high}, and no row names
}
\seealso{
\link{confint}
}

