% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_compute_terms_contributions.R
\name{model_compute_terms_contributions}
\alias{model_compute_terms_contributions}
\alias{model_compute_terms_contributions.default}
\title{Compute a matrix of terms contributions}
\usage{
model_compute_terms_contributions(model)

\method{model_compute_terms_contributions}{default}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
Used for \code{\link[=model_get_n]{model_get_n()}}. For each row and term, equal 1 if this row should
be taken into account in the estimate of the number of observations,
0 otherwise.
}
\details{
This function does not cover \code{lavaan} models (\code{NULL} is returned).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- lm(Sepal.Length ~ Sepal.Width, iris)
mod \%>\% model_compute_terms_contributions()

mod <- lm(hp ~ mpg + factor(cyl) + disp:hp, mtcars)
mod \%>\% model_compute_terms_contributions()

mod <- glm(
  response ~ stage * grade + trt,
  gtsummary::trial,
  family = binomial,
  contrasts = list(
    stage = contr.sum,
    grade = contr.treatment(3, 2),
    trt = "contr.SAS"
  )
)
mod \%>\% model_compute_terms_contributions()

mod <- glm(
  response ~ stage * trt,
  gtsummary::trial,
  family = binomial,
  contrasts = list(stage = contr.poly)
)
mod \%>\% model_compute_terms_contributions()

mod <- glm(
  Survived ~ Class * Age + Sex,
  data = Titanic \%>\% as.data.frame(),
  weights = Freq, family = binomial
)
mod \%>\% model_compute_terms_contributions()

d <- dplyr::as_tibble(Titanic) \%>\%
  dplyr::group_by(Class, Sex, Age) \%>\%
  dplyr::summarise(
    n_survived = sum(n * (Survived == "Yes")),
    n_dead = sum(n * (Survived == "No"))
  )
mod <- glm(cbind(n_survived, n_dead) ~ Class * Age + Sex, data = d, family = binomial)
mod \%>\% model_compute_terms_contributions()
\dontshow{\}) # examplesIf}
}
\seealso{
Other model_helpers: 
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
