% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{ranef.brmsfit}
\alias{ranef.brmsfit}
\alias{ranef}
\title{Extract Group-Level Estimates}
\usage{
\method{ranef}{brmsfit}(object, summary = TRUE, robust = FALSE,
  probs = c(0.025, 0.975), pars = NULL, groups = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{pars}{Optional names of coefficients to extract.
By default, all coefficients are extracted.}

\item{groups}{Optional names of grouping variables
for which to extract effects.}

\item{...}{Currently ignored.}
}
\value{
If \code{old} is \code{FALSE}: A list of arrays 
 (one per grouping factor). If \code{summary} is \code{TRUE},
 names of the first dimension are the factor levels and names
 of the third dimension are the group-level effects. 
 If \code{summary} is \code{FALSE}, names of the second dimension
 are the factor levels and names of the third dimension are the 
 group-level effects.
}
\description{
Extract the group-level ('random') effects of each level 
from a \code{brmsfit} object.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit), 
           data = epilepsy, family = gaussian(), chains = 2)
ranef(fit)
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
