% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{StudentT}
\alias{StudentT}
\alias{dstudent_t}
\alias{pstudent_t}
\alias{qstudent_t}
\alias{rstudent_t}
\title{The Student-t Distribution}
\usage{
dstudent_t(x, df, mu = 0, sigma = 1, log = FALSE)

pstudent_t(q, df, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qstudent_t(p, df, mu = 0, sigma = 1)

rstudent_t(n, df, mu = 0, sigma = 1)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{df}{Vector of degrees of freedom.}

\item{mu}{Vector of location values.}

\item{sigma}{Vector of scale values.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x).
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{p}{Vector of probabilities.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Density, distribution function, quantile function and random generation
for the Student-t distribution with location \code{mu}, scale \code{sigma},
and degrees of freedom \code{df}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
\seealso{
\code{\link[stats:TDist]{TDist}}
}
