% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{validate_prior}
\alias{validate_prior}
\title{Validate Prior for \pkg{brms} Models}
\usage{
validate_prior(
  prior,
  formula,
  data,
  family = gaussian(),
  sample_prior = "no",
  data2 = NULL,
  knots = NULL,
  ...
)
}
\arguments{
\item{prior}{One or more \code{brmsprior} objects created by
\code{\link{set_prior}} or related functions and combined using the
\code{c} method or the \code{+} operator. See also  \code{\link{get_prior}}
for more help.}

\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}

\item{family}{A description of the response distribution and link function to
be used in the model. This can be a family function, a call to a family
function or a character string naming the family. Every family function has
a \code{link} argument allowing to specify the link function to be applied
on the response variable. If not specified, default links are used. For
details of supported families see \code{\link{brmsfamily}}. By default, a
linear \code{gaussian} model is applied. In multivariate models,
\code{family} might also be a list of families.}

\item{sample_prior}{Indicate if draws from priors should be drawn
additionally to the posterior draws. Options are \code{"no"} (the
default), \code{"yes"}, and \code{"only"}. Among others, these draws can
be used to calculate Bayes factors for point hypotheses via
\code{\link{hypothesis}}. Please note that improper priors are not sampled,
including the default improper priors used by \code{brm}. See
\code{\link{set_prior}} on how to set (proper) priors. Please also note
that prior draws for the overall intercept are not obtained by default
for technical reasons. See \code{\link{brmsformula}} how to obtain prior
draws for the intercept. If \code{sample_prior} is set to \code{"only"},
draws are drawn solely from the priors ignoring the likelihood, which
allows among others to generate draws from the prior predictive
distribution. In this case, all parameters must have proper priors.}

\item{data2}{A named \code{list} of objects containing data, which
cannot be passed via argument \code{data}. Required for some objects
used in autocorrelation structures to specify dependency structures
as well as for within-group covariance matrices.}

\item{knots}{Optional list containing user specified knot values to be used
for basis construction of smoothing terms. See
\code{\link[mgcv:gamm]{gamm}} for more details.}

\item{...}{Other arguments for internal usage only.}
}
\value{
An object of class \code{brmsprior}.
}
\description{
Validate priors supplied by the user. Return a complete
set of priors for the given model, including default priors.
}
\examples{
prior1 <- prior(normal(0,10), class = b) +
  prior(cauchy(0,2), class = sd)
validate_prior(prior1, count ~ zAge + zBase * Trt + (1|patient),
               data = epilepsy, family = poisson())

}
\seealso{
\code{\link{get_prior}}, \code{\link{set_prior}}.
}
