% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-helpers.R
\name{compare_ic}
\alias{compare_ic}
\title{Compare Information Criteria of Different Models}
\usage{
compare_ic(..., x = NULL)
}
\arguments{
\item{...}{At least two objects returned by 
\code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.}

\item{x}{A list of at least two objects returned by
\code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.
This argument can be used as an alternative to specifying the 
models in \code{...}.}
}
\value{
An object of class \code{iclist}.
}
\description{
Compare information criteria of different models fitted
with \code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.
}
\details{
For more details see \code{\link[loo:compare]{compare}}.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
w1 <- WAIC(fit1)

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
w2 <- WAIC(fit2)

# compare both models
compare_ic(w1, w2)
}

}
\seealso{
\code{\link[brms:WAIC]{WAIC}}, 
  \code{\link[brms:LOO]{LOO}},
  \code{\link[loo:compare]{compare}}
}

