% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_stancode.R
\name{make_stancode}
\alias{make_stancode}
\title{Stan Code for \pkg{brms} Models}
\usage{
make_stancode(formula, data = NULL, family = gaussian(), prior = NULL,
  autocor = NULL, nonlinear = NULL, partial = NULL,
  threshold = c("flexible", "equidistant"), cov_ranef = NULL,
  sample_prior = FALSE, save_model = NULL, ...)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class): 
a symbolic description of the model to be fitted. 
The details of model specification are given under 'Details'.}

\item{data}{An optional data frame, list or environment  (or object coercible by 
\code{as.data.frame} to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from \code{environment(formula)}, 
typically the environment from which \code{brm} is called. 
Although it is optional, we strongly recommend to supply a data.frame.}

\item{family}{A description of the error distribution and link function 
to be used in the model. This can be a family function, 
a call to a family function or a character string naming the family.
Currently, the following families are supported:
\code{gaussian}, \code{student}, \code{cauchy} (deprecated), \code{binomial}, 
\code{bernoulli}, \code{Beta}, \code{poisson}, \code{negbinomial}, 
\code{geometric}, \code{Gamma}, \code{inverse.gaussian}, 
\code{exponential}, \code{weibull}, \code{categorical}, \code{cumulative}, 
\code{cratio}, \code{sratio}, \code{acat}, \code{hurdle_poisson}, 
\code{hurdle_negbinomial}, \code{hurdle_gamma}, \code{zero_inflated_binomial},
\code{zero_inflated_beta}, \code{zero_inflated_negbinomial}, 
and \code{zero_inflated_poisson}.
Every family function has a \code{link} argument allowing to specify
the link function to be applied on the response variable.
If not specified, default links are used.
See \code{\link[stats:family]{family}} for help on standard family functions 
and \code{\link[brms:brmsfamily]{brmsfamily}} for family functions
specific to the \pkg{brms} package. 
For backwards compatibility, \code{family} may also be a vector of two
character strings, the first naming the family and the second naming the link.
Further information is provided under 'Details'.}

\item{prior}{One or more \code{brmsprior} objects created by function 
\code{\link[brms:set_prior]{set_prior}} and combined using the \code{c} method. 
A single \code{brmsprior} object may be passed without \code{c()} surrounding it. 
See also  \code{\link[brms:get_prior]{get_prior}} for more help.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing 
the correlation structure 
within the response variable (i.e. the 'autocorrelation'). 
See the documentation of \code{\link{cor_brms}} for a description 
of the available correlation structures. Defaults to NULL, 
corresponding to no correlations.}

\item{nonlinear}{An optional list of formuluas, specifying 
linear models for non-linear parameters. If \code{NULL} (the default)
\code{formula} is treated as an ordinary formula. 
If not \code{NULL}, \code{formula} is treated as a non-linear model
and \code{nonlinear} should contain a formula for each non-linear 
parameter, which has the parameter on the left hand side and its
linear predictor on the right hand side.
Alternatively, it can be a single formula with all non-linear
parameters on the left hand side (separated by a \code{+}) and a
common linear predictor on the right hand side.
More information is given under 'Details'.}

\item{partial}{A one sided formula of the form \code{~expression} 
allowing to specify predictors with category specific effects 
in non-cumulative ordinal models 
(i.e. in families \code{cratio}, \code{sratio}, or \code{acat}).}

\item{threshold}{A character string indicating the type of thresholds 
(i.e. intercepts) used in an ordinal model. 
\code{"flexible"} provides the standard unstructured thresholds and 
\code{"equidistant"} restricts the distance between 
consecutive thresholds to the same value.}

\item{cov_ranef}{A list of matrices that are proportional to the 
(within) covariance structure of the random effects. 
The names of the matrices should correspond to columns 
in \code{data} that are used as grouping factors. 
All levels of the grouping factor should appear as rownames 
of the corresponding matrix.}

\item{sample_prior}{A flag to indicate if samples from all specified proper priors 
should be additionally drawn. Among others, these samples can be used to calculate 
Bayes factors for point hypotheses. Default is \code{FALSE}.}

\item{save_model}{Either \code{NULL} or a character string. 
In the latter case, the model code is
saved in a file named after the string supplied in \code{save_model}, 
which may also contain the full path where to save the file.
If only a name is given, the file is save in the current working directory.}

\item{...}{Other arguments for internal usage only}
}
\value{
A character string containing the fully commented \pkg{Stan} code 
  to fit a \pkg{brms} model.
}
\description{
Generate Stan code for \pkg{brms} models
}
\examples{
make_stancode(rating ~ treat + period + carry + (1|subject), 
              data = inhaler, family = "cumulative")

make_stancode(count ~ log_Age_c + log_Base4_c * Trt_c 
              + (1|patient) + (1|visit), 
              data = epilepsy, family = "poisson")

}

