% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-history.R
\name{db_sql_query_history}
\alias{db_sql_query_history}
\title{List Warehouse Query History}
\usage{
db_sql_query_history(
  statuses = NULL,
  user_ids = NULL,
  endpoint_ids = NULL,
  start_time_ms = NULL,
  end_time_ms = NULL,
  max_results = 100,
  page_token = NULL,
  include_metrics = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{statuses}{Allows filtering by query status. Possible values are:
\code{QUEUED}, \code{RUNNING}, \code{CANCELED}, \code{FAILED}, \code{FINISHED}. Multiple permitted.}

\item{user_ids}{Allows filtering by user ID's. Multiple permitted.}

\item{endpoint_ids}{Allows filtering by endpoint ID's. Multiple permitted.}

\item{start_time_ms}{Integer, limit results to queries that started after this time.}

\item{end_time_ms}{Integer, limit results to queries that started before this time.}

\item{max_results}{Limit the number of results returned in one page. Default is 100.}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{include_metrics}{Whether to include metrics about query execution.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
For more details refer to the \href{https://docs.databricks.com/sql/api/query-history.html#list}{query history documentation}.
This function elevates the sub-components of \code{filter_by} parameter to the R
function directly.
}
\details{
By default the filter parameters \code{statuses}, \code{user_ids}, and \code{endpoints_ids}
are \code{NULL}.
}
\concept{SQL Query History API}
