% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{Plotting GLM graphs}
\alias{Plotting GLM graphs}
\alias{plot.brainGraph_NBS}
\alias{plot.brainGraph_GLM}
\alias{plot.brainGraph_mtpc}
\alias{plot.brainGraph_mediate}
\title{Plot a graph with results from GLM-based analyses}
\usage{
\method{plot}{brainGraph_NBS}(x, alpha = 0.05,
  subgraph = paste("p.nbs >", 1 - alpha), vertex.label = NA,
  vertex.color = "color.comp", edge.color = "color.comp",
  subtitle = NULL, main = paste0("NBS: ", x$name), cex.main = 2, ...)

\method{plot}{brainGraph_GLM}(x, p.sig = c("p", "p.fdr", "p.perm"),
  subgraph = NULL, main = paste0(x$outcome, ": ", x$name),
  subtitle = NULL, cex.main = 2, ...)

\method{plot}{brainGraph_mtpc}(x, subgraph = "sig == 1",
  main = paste0(x$outcome, ": ", x$name), subtitle = NULL,
  cex.main = 2, ...)

\method{plot}{brainGraph_mediate}(x, subgraph = "p.acme > 0.95",
  main = sprintf("Effect of \\"\%s\\" on\\n\\"\%s\\"\\nmediated by \\"\%s\\"",
  x$treat, x$outcome, x$mediator), subtitle = NULL, cex.main = 1, ...)
}
\arguments{
\item{x}{A \code{brainGraph_GLM}, \code{brainGraph_mtpc},
\code{brainGraph_mediate}, or \code{brainGraph_NBS} object}

\item{alpha}{Numeric; the significance level. Default: \code{0.05}}

\item{subgraph}{Character string specifying the condition for subsetting the
graph.}

\item{vertex.label}{Character vector of the vertex labels to be displayed.}

\item{vertex.color}{Character string specifying the vertex attribute to color
the vertices by.}

\item{edge.color}{Character string specifying the edge attribute to color
the edges by.}

\item{subtitle}{Character string; the subtitle. Default: \code{'default'}}

\item{main}{Character string; the main title. Default: \code{NULL}}

\item{cex.main}{Numeric; the scaling factor for text size; see
\code{\link[graphics]{par}}}

\item{...}{Other arguments passed to \code{\link{plot.brainGraph}}}

\item{p.sig}{Character string indicating which p-value to use for determining
significance (default: \code{p})}
}
\description{
These methods are convenience functions for plotting a graph based on results
from GLM-based analyses (i.e., \code{\link{brainGraph_GLM},
\link{brainGraph_mediate}, \link{mtpc}, \link{NBS}}). There are several
default arguments which differ depending on the input object.
}
\details{
The default arguments are specified so that the user only needs to type
\code{plot(x)} at the console, if desired. For all methods, the plot's
\emph{subtitle} will be omitted.
}
\section{NBS}{

By default, a subgraph will be plotted consisting of only those vertices
which are part of a significant connected component. Vertex/edge colors will
correspond to connected component membership. Vertex names will be omitted.
Finally, the plot title will contain the contrast name.
}

\section{brainGraph_GLM}{

By default, a subgraph will be plotted consisting of only those vertices for
which \eqn{p < \alpha}. It will also include a plot title with the outcome
measure and contrast name.
}

\section{mtpc}{

By default, a subgraph will be plotted consisting of only those vertices for
which \eqn{A_{mtpc} > A_{crit}}. It will also include a plot title with the
outcome measure and contrast name.
}

\section{brainGraph_mediate}{

By default, a subgraph will be plotted consisting of only those vertices for
which \eqn{P_{acme} < \alpha}. It will also include a plot title with the
treatment, mediator, and outcome variable names.
}

\seealso{
Other Plotting functions: \code{\link{plot.brainGraphList}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_multi}}
}
\concept{Plotting functions}
