% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resid.R, R/methods.R
\name{Residuals}
\alias{Residuals}
\alias{get.resid}
\alias{Extract.brainGraph_resids}
\alias{[.brainGraph_resids}
\alias{summary.brainGraph_resids}
\alias{plot.brainGraph_resids}
\alias{nobs.brainGraph_resids}
\alias{case.names.brainGraph_resids}
\alias{groups.brainGraph_resids}
\alias{region.names.brainGraph_resids}
\alias{nregions.brainGraph_resids}
\title{Linear model residuals in structural covariance networks}
\usage{
get.resid(dt.vol, covars, method = c("comb.groups", "sep.groups"),
  use.mean = FALSE, exclude.cov = NULL, atlas = NULL, ...)

\method{[}{brainGraph_resids}(x, i, g = NULL)

\method{summary}{brainGraph_resids}(object, region = NULL,
  outlier.thresh = 2, ...)

\method{plot}{brainGraph_resids}(x, region = NULL, outlier.thresh = 2,
  cols = FALSE, ids = TRUE, ...)

\method{nobs}{brainGraph_resids}(object, ...)

\method{case.names}{brainGraph_resids}(object, ...)

\method{groups}{brainGraph_resids}(x)

\method{region.names}{brainGraph_resids}(object)

\method{nregions}{brainGraph_resids}(object)
}
\arguments{
\item{dt.vol}{A \code{data.table} containing all the volumetric measure of
interest (i.e., the object \code{lhrh} as output by
\code{\link{import_scn}})}

\item{covars}{A \code{data.table} of the covariates of interest}

\item{method}{Character string indicating whether to test models for subject
groups separately or combined. Default: \code{comb.groups}}

\item{use.mean}{Logical should we control for the mean hemispheric brain
value (e.g. mean LH/RH cortical thickness). Default: \code{FALSE}}

\item{exclude.cov}{Character vector of covariates to exclude. Default:
\code{NULL}}

\item{atlas}{Character string indicating the brain atlas}

\item{...}{Arguments passed to \code{\link{brainGraph_GLM_design}} (optional)}

\item{x, object}{A \code{brainGraph_resids} object}

\item{i}{Numeric vector of the indices}

\item{g}{Character string indicating the group. Default: \code{NULL}}

\item{region}{Character vector of region(s) to focus on; default behavior is
to show summary for all regions}

\item{outlier.thresh}{Number indicating how many standard deviations
above/below the mean indicate an outlier. Default: \code{2}}

\item{cols}{Logical indicating whether to color by group. Default:
\code{FALSE}}

\item{ids}{Logical indicating whether to plot subject ID's for outliers.
Otherwise plots the integer index}
}
\value{
\code{get.resid} - an object of class \code{brainGraph_resids} with
  elements:
  \item{data}{A data.table with the input volume/thickness/etc. data as well
    as the covariates used in creating the design matrix.}
  \item{X}{The \emph{design matrix}, if using default arguments. If
  \code{use.mean=TRUE} then it will be a \emph{named list} with a separate
  matrix for the left and right hemispheres. If \code{method='sep.groups'}, a
  nested named list for each group and hemisphere.}
  \item{method}{The input argument \code{method}}
  \item{use.mean}{The input argument \code{use.mean}}
  \item{resids.all}{The \dQuote{wide} \code{data.table} of residuals}
  \item{Group}{Group names}
  \item{atlas}{The atlas name}

\code{\link{summary.brainGraph_resids}} returns a list with two
  data tables, one of the residuals, and one of only the outlier regions

The \code{plot} method returns a \code{trellis} object or a list of
  \code{ggplot} objects
}
\description{
\code{get.resid} runs linear models across brain regions listed in a
\code{data.table} (e.g., cortical thickness), adjusting for variables in
\code{covars} (e.g. age, sex, etc.), and calculates the
\emph{externally Studentized} (or \emph{leave-one-out}) residuals.

The \code{[} method reorders or subsets residuals based on a given
numeric vector. However, this is used in bootstrap and permutation analysis
and should generally not be called directly by the user.

The \code{summary} method prints the number of outliers per region, and the
number of times a given subject was an outlier (i.e., across regions).

The \code{plot} method lets you check the model residuals for each brain
region in a structural covariance analysis. It shows a \emph{qqplot} of the
studentized residuals, as output from \code{\link{get.resid}}.
}
\details{
You can choose to run models for each of your subject groups separately or
combined (the default) via the \code{method} argument. You may also choose
whether to include the mean, per-hemisphere structural measure in the
models. Finally, you can specify variables that are present in \code{covars}
which you would like to exclude from the models. Optional arguments can be
provided that get passed to \code{\link{brainGraph_GLM_design}}.

If you do not explicitly specify the atlas name, then it will be guessed from
the size of your data. This could cause problems if you are using a custom
atlas, with or without the same number of regions as a dataset in the
package.
}
\note{
It is assumed that \code{dt.vol} was created using
\code{\link{import_scn}}. In older versions, there were issues when the Study
ID was specified as an integer and was not \dQuote{zero-padded}. This is done
automatically by \code{\link{import_scn}}, so if you are using an external
program, please be sure that the Study ID column is matched in both
\code{dt.vol} and \code{covars}.
}
\examples{
\dontrun{
myresids <- get.resids(lhrh, covars)
residPlots <- plot(myresids, cols=TRUE)

## Save as a multi-page PDF
ml <- marrangeGrob(residPlots, nrow=3, ncol=3)
ggsave('residuals.pdf', ml)
}
}
\seealso{
\code{\link[stats]{influence.measures}}, \code{\link[stats]{qqnorm}}

Other Structural covariance network functions: \code{\link{Bootstrapping}},
  \code{\link{IndividualContributions}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{import_scn}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Structural covariance network functions}
