% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_glm_brainGraph}
\alias{make_glm_brainGraph}
\title{Create a graph with GLM-specific attributes}
\usage{
make_glm_brainGraph(res.glm, atlas, ...)
}
\arguments{
\item{res.glm}{List as output by \code{\link{brainGraph_GLM}} or by
\code{\link{mtpc}}.}

\item{atlas}{Character string specifying the brain atlas to use}

\item{...}{Other arguments passed to \code{\link{make_brainGraph}}}
}
\value{
A list of \code{igraph} graph objects (length equal to the number of
  contrasts) with additional attributes:
  \item{Graph}{\emph{name} (contrast name), \emph{outcome} (the outcome
    variable), \emph{alpha} (the significance level); for MTPC:
    \emph{tau.mtpc}, \emph{S.mtpc}, \emph{S.crit}, \emph{A.crit}}
  \item{Vertex}{\emph{size2} (t-statistic), \emph{size} (the t-stat
    transformed for visualization purposes), \emph{p} (equal to \eqn{1-p}),
    \emph{p.fdr} (equal to \eqn{1-p_{FDR}}, the FDR-adjusted p-value),
    \emph{gamma} (the contrast of parameter estimaties, \emph{se} (the
    standard error of \emph{gamma}); \emph{A.mtpc}, \emph{sig} (binary
    indicating whether \code{A.mtpc > A.crit}) (for MTPC)}
}
\description{
\code{make_glm_brainGraph} will create graphs with attributes specific to the
results of \code{\link{brainGraph_GLM}} or \code{\link{mtpc}}. The function
returns a list, with one element for each specified contrast.
}
\details{
This function only creates a graph for \emph{vertex}-level analyses.
}
\seealso{
\code{\link{brainGraph_GLM}, \link{mtpc}}

Other Graph creation functions: \code{\link{make_brainGraph}},
  \code{\link{make_ego_brainGraph}},
  \code{\link{make_empty_brainGraph}},
  \code{\link{make_mediate_brainGraph}},
  \code{\link{make_nbs_brainGraph}}
}
\concept{Graph creation functions}
