% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_module_degree_z_score.R
\name{within_module_deg_z_score}
\alias{within_module_deg_z_score}
\title{Calculate vertex within-module degree z-score}
\usage{
within_module_deg_z_score(g, memb)
}
\arguments{
\item{g}{The graph}

\item{memb}{The community membership indices of each vertex}
}
\value{
A vector of the within-module degree z-scores for each vertex of the
graph.
}
\description{
This function calculates the within-module degree z-score of each vertex in a
graph, based on some module membership. This is a measure of the connectivity
from a given vertex to other vertices in its module.
}
\details{
The within-module degree z-score is:
\deqn{z_i = \frac{\kappa_i - \bar{\kappa}_{s_i}}{\sigma_{\kappa_{s_i}}}}
where \eqn{\kappa_i} is the number of edges from vertex \emph{i} to vertices
in the same module \eqn{s_i}, \eqn{\bar{\kappa}_{s_i}} is the average of
\eqn{\kappa} over all vertices in \eqn{s_i}, and \eqn{\sigma_{\kappa_{s_i}}}
is the standard deviation.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Guimera, R. and Amaral, L.A.N. (2005) Cartography of complex
networks: modules and universal roles, Journal of Statistical Mechanics:
Theory and Experiment, 02, P02001.
}

