% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{BFc.bpnme}
\alias{BFc.bpnme}
\title{Bayes Factors for a Bayesian circular mixed-effects model}
\usage{
\method{BFc}{bpnme}(object, hypothesis, type = "anchor")
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}.}

\item{hypothesis}{the inequality constrained hypothesis to test.}

\item{type}{type of hypothesis to test \code{c("anchor", "isotropic")}. As of
yet only anchor hypotheses can be tested.}
}
\value{
Bayes Factors for inequality constrained hypotheses on mean
  differences.
}
\description{
Outputs Bayes Factors for inequality constrained hypotheses on the circular
differences between several levels of a categorical variable and the
baseline.
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps, its = 100, burn = 1, n.lag = 1)
BFc(fit.Maps, hypothesis = "Maze1 < Trial.type1")

}
