% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{residuals.bpnr}
\alias{residuals.bpnr}
\title{Residuals for a Bayesian circular regression model}
\usage{
\method{residuals}{bpnr}(object, type = "arc", ...)
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function
\code{\link{bpnr}}.}

\item{type}{the type of residuals, one of \code{c("arc", "cos")}. The
\code{"arc"} residuals are based on a computation of the circular arc
length between predicted value and original outcome. The \code{"cos"}
residuals are based on the cosine of the difference between predicted value
and original outcome.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix (rows = N, columns = iterations) containing residuals for
  each iteration of the MCMC sampler.
}
\description{
Outputs residuals for a Bayesian circular regression model for each iteration
of the MCMC sampler.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
residuals(fit.Motor)
residuals(fit.Motor, type = "cos")

}
