% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_stages.R
\name{bp_stages}
\alias{bp_stages}
\title{Alternative Blood Pressure Stages}
\usage{
bp_stages(
  data,
  sbp,
  dbp,
  inc_low = TRUE,
  inc_crisis = TRUE,
  data_screen = TRUE,
  SUL = 240,
  SLL = 50,
  DUL = 140,
  DLL = 40,
  adj_sbp_dbp = TRUE
)
}
\arguments{
\item{data}{User-supplied dataset containing blood pressure data. Must
contain data for Systolic blood pressure and Diastolic blood pressure at a
minimum.}

\item{sbp}{column name corresponding to systolic blood pressure (SBP)}

\item{dbp}{column name corresponding to diastolic blood pressure (DBP)}

\item{inc_low}{A TRUE / FALSE indicator of whether or not to include the "Low" (Hypotension)
category to the scatter plot. The range for Hypotension is set from a minimum of 25 for DBP or 80
for SBP, or the corresponding minimum value for either category from the data until 60 for DBP and
100 for SBP.}

\item{inc_crisis}{A TRUE / FALSE indicator of whether or not to include the Hypertensive "Crisis"
category to the scatter plot. The range for crisis is any value above 180 for SBP or above 120 for
DBP.}

\item{data_screen}{Default to TRUE. data_screens for extreme values in the data for both \code{SBP} and \code{DBP}
according to Omboni, et al (1995) paper - Calculation of Trough:Peak Ratio of Antihypertensive Treatment
from Ambulatory Blood Pressure: Methodological Aspects}

\item{SUL}{Systolic Upper Limit (SUL). If \code{data_screen = TRUE}, then \code{SUL} sets the upper limit by which
to exclude any \code{SBP} values that exceed this threshold. The default is set to 240 per Omboni, et al (1995)
paper - Calculation of Trough:Peak Ratio of Antihypertensive Treatment from Ambulatory Blood Pressure:
Methodological Aspects}

\item{SLL}{Systolic Lower Limit (SLL). If \code{data_screen = TRUE}, then \code{SLL} sets the lower limit by which
to exclude any \code{SBP} values that fall below this threshold. The default is set to 50 per Omboni, et al (1995)
paper - Calculation of Trough:Peak Ratio of Antihypertensive Treatment from Ambulatory Blood Pressure:
Methodological Aspects}

\item{DUL}{Diastolic Upper Limit (DUL). If \code{data_screen = TRUE}, then \code{DUL} sets the upper limit by which
to exclude any \code{DBP} values that exceed this threshold. The default is set to 140 per Omboni, et al (1995)
paper - Calculation of Trough:Peak Ratio of Antihypertensive Treatment from Ambulatory Blood Pressure:
Methodological Aspects}

\item{DLL}{Diastolic Lower Limit (DLL). If \code{data_screen = TRUE}, then \code{DLL} sets the lower limit by which
to exclude any \code{DBP} values that fall below this threshold. The default is set to 40 per Omboni, et al (1995)
paper - Calculation of Trough:Peak Ratio of Antihypertensive Treatment from Ambulatory Blood Pressure:
Methodological Aspects}

\item{adj_sbp_dbp}{Logical indicator to dictate whether or not to run helper functions that adjust / process
SBP & DBP columns in supplied data set. Default set to: \code{adj_sbp_dbp = TRUE}}
}
\value{
A dataframe with additional columns corresponding to the stages of high blood pressure and the
supplementary SBP / DBP categories
}
\description{
Adds BP_CLASS, SBP_Category, and DBP_Category columns to supplied dataframe.
}
\details{
Supplied dataframe must adhere to the unified format using the \code{process_data} function.
}
\examples{
# Load bp_hypnos
data(bp_hypnos)

bp_stages(bp_hypnos, sbp = "syst", dbp = "diast")


# Load bp_jhs data
data(bp_jhs)

bp_stages(bp_jhs, sbp = "sys.mmhg.", dbp = "dias.mmhg.")

}
\references{
Omboni, S., Parati, G*., Zanchetti, A., Mancia, G. Calculation of trough: peak ratio of
antihypertensive treatment from ambulatory blood pressure: methodological aspects
\emph{Journal of Hypertension}. October 1995 - Volume 13 - Issue 10 - p 1105-1112
\doi{10.1097/00004872-199510000-00005}
}
