% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/boxr_upload_download.R
\name{box_dl}
\alias{box_dl}
\alias{box_ul}
\title{Download and upload individual files from box.com}
\usage{
box_dl(file_id, local_dir = getwd(), overwrite = FALSE, filename = NULL,
  version_id = NULL, version_no = NULL)

box_ul(dir_id = box_getwd(), file)
}
\arguments{
\item{file_id}{The box.com id for the file that you'd like to download}

\item{local_dir}{A file path to a local directory which you'd like the file
to be downloaded to.}

\item{overwrite}{\code{logical}. Should existing files with the same name be
overwritten?}

\item{filename}{Optional. An alternate filename for the local version of the
file. The default, \code{NULL}, uses the name from box.com.}

\item{version_id}{If downloading an older version, the \code{version_id} of
the desired file}

\item{version_no}{The version of the file you'd like to download (starting at
  1)}

\item{dir_id}{If uploading, the box.com folder id that you'd like to upload
to.}

\item{file}{the path to the local file that you'd like to upload (if there is
one)}
}
\value{
\code{box_dl} will return \code{TRUE} for a successful download, and throw
    an error otherwise

  \code{box_ul} will return an object describing the new remote file

  \code{box_read} will reaturn an \bold{\code{R}} object
}
\description{
{
  Functions to download (\code{box_dl}), and upload (\code{box_ul}), files,
  as well as read remote files straight into memory (\code{box_read}).

  \code{box_dl} takes the \code{id} of a file hosted on box.com, downloads
    it and writes it to disk.

  \code{box_ul} uploads a file stored locally to a specified box.com folder.
    If a file with the same name already exists, it will store a new version
    of the file.
}
}
\section{Versions}{

  \describe{
    \code{box_dl} can accept one of two parameters to specify file versions.

    The box.com API refers to file versions using 11 digit ids (which can be
    accessed via \code{\link{box_previous_versions}}) - you can specify these
    using the \code{version_id} parameter.

    However, this isn't terribly intuative. As a result, \code{box_dl}
    provides the \code{version_no} parameter, which accepts a whole number,
    and corresponds to the versions that you'll see via the web UI. For
    example to download the version marked 'V2' on box.com, specify
    \code{version_no = 2}. This works by making an internal call to
    \code{\link{box_previous_versions}} to retrieve the \code{version_id},
    which makes it slightly slower.
  }
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}
\seealso{
\code{\link{box_fetch}} and \code{\link{box_push}} for
  directory-wide equivalents, \code{\link{box_delete_file}} for removing
  uploaded files, \code{\link{box_source}} for R code, and
  \code{\link{box_save}}/\code{\link{box_load}} for remote R objects.
}

