% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_ardl.R
\name{boot_ardl}
\alias{boot_ardl}
\title{Bootstrap ARDL}
\usage{
boot_ardl(
  data,
  yvar = NULL,
  Xvar = NULL,
  difflags = NULL,
  maxlag = 5,
  p.ardl = 0.05,
  p.vecm = 0.05,
  B = 2000,
  case = 3,
  crit.H0 = c(0.05, 0.025, 0.01),
  print = TRUE
)
}
\arguments{
\item{data}{Input dataset. Must contain a dependent and a set of independent variables.}

\item{yvar}{Name of the dependent variable, enclosed in quotation marks. If NULL, the first variable will be used.}

\item{Xvar}{Vector of names of the independent variables, each enclosed in quotation marks. If NULL, all variables except the first will be used.}

\item{difflags}{Fixed lagged differences for the short term part of the ARDL equation.}

\item{maxlag}{Max number of lags for the auto_ardl procedure.}

\item{p.ardl}{Threshold p-value for the short-term ARDL coefficients significance in the bootstrap procedure.}

\item{p.vecm}{Threshold p-value for the short-term VECM coefficients significance in the bootstrap procedure.}

\item{B}{Number of bootstrap replications.}

\item{case}{Model case, pertaining to the treatment of intercept and trend. Must be integer from 1 to 5. Defaults to 3.}

\item{crit.H0}{Probability/ies by which the critical quantiles of the bootstrap distribution(s) must be calculated.}

\item{print}{Show the progress bar.}
}
\value{
List of several elements including \itemize{
\item \code{ARDL}: the conditional and unconditional ARDL models applied on the data
\item \code{pssbounds}: the PSS bound test output
\item \code{smgbounds}: the SMG bound test critical values
\item \code{fov.st}: the test statistics on the conditional and unconditional Fov tests
\item \code{t.st}: the test statistics on the conditional and unconditional t tests
\item \code{find.st}: the test statistics on the conditional and unconditional Find tests
\item \code{quantFOV}: the bootstrap conditional and unconditional F Overall test critical value(s)
\item \code{quantt}: the bootstrap conditional and unconditional t test critical value(s)
\item \code{quantFIND}: the bootstrap conditional and unconditional F Independent test critical value(s)}
}
\description{
Bootstrap ARDL
}
\examples{
\donttest{
data(ger_macro)
LNDATA = as.data.frame(log(ger_macro[,-1]))
colnames(LNDATA) = c("LNINVEST","LNINCOME","LNCONS")

boot_res = boot_ardl(LNDATA, yvar = "LNINCOME", Xvar = c("LNCONS","LNINVEST"), maxlag = 5, B = 2000)
summary(boot_res)
}
}
