\name{print.boot}
\alias{print.boot}
\title{
Print a Summary of a Bootstrap Object
}
\description{
This is a method for the function print for objects of the class \code{"boot"}.
}
\usage{
\method{print}{boot}(x, digits = getOption("digits"), 
      index = 1:ncol(boot.out$t), \dots)
}
\arguments{
  \item{x}{
    A bootstrap output object of class \code{"boot"} generated by one
    of the bootstrap functions.
  }
  \item{digits}{
    The number of digits to be printed in the summary statistics.
  }
  \item{index}{
    Indices indicating for which elements of the bootstrap output
    summary statistics are required.
  }
  \item{\dots}{further arguments passed to or from other methods.}
}
\value{
  The bootstrap object is returned invisibly.
}
\details{
  For each statistic calculated in the bootstrap the original value and
  the bootstrap estimates of its bias and standard error are printed.
  If \code{boot.out$t0} is missing (such as when it was created by a
  call to \code{tsboot} with \code{orig.t=FALSE}) the bootstrap mean and
  standard error are printed. If resampling was done using importance
  resampling weights, then the bootstrap estimates are reweighted as if
  uniform resampling had been done.  The ratio importance sampling
  estimates are used and if there were a number of distributions then
  defensive mixture distributions are used.  In this case an extra
  column with the mean of the observed bootstrap statistics is also
  printed.
}
\seealso{
  \code{\link{boot}}, \code{\link{censboot}}, \code{\link{imp.moments}},
  \code{\link{plot.boot}}, \code{\link{tilt.boot}}, \code{\link{tsboot}}
}
\keyword{nonparametric}
\keyword{htest}
