% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{boom_shinyApp}
\alias{boom_shinyApp}
\alias{boom_runApp}
\title{boom the reactive calls of a shiny app}
\usage{
boom_shinyApp(
  ui,
  server,
  onStart = NULL,
  options = list(),
  uiPattern = "/",
  enableBookmarking = NULL
)

boom_runApp(
  appDir = getwd(),
  port = getOption("shiny.port"),
  launch.browser = getOption("shiny.launch.browser", interactive()),
  host = getOption("shiny.host", "127.0.0.1"),
  workerId = "",
  quiet = FALSE,
  display.mode = c("auto", "normal", "showcase"),
  test.mode = getOption("shiny.testmode", FALSE)
)
}
\arguments{
\item{ui}{The UI definition of the app (for example, a call to
\code{fluidPage()} with nested controls).

If bookmarking is enabled (see \code{enableBookmarking}), this must be
a single argument function that returns the UI definition.}

\item{server}{A function with three parameters: \code{input}, \code{output}, and
\code{session}. The function is called once for each session ensuring that each
app is independent.}

\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{enableBookmarking}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. The default value, \code{NULL}, will respect the setting from
any previous calls to  \code{\link[shiny:enableBookmarking]{enableBookmarking()}}. See \code{\link[shiny:enableBookmarking]{enableBookmarking()}}
for more information on bookmarking your app.}

\item{appDir}{Path to directory that contains a Shiny app (i.e. a server.R
file and either ui.R or www/index.html)}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. The value of this parameter can also be a
function to call with the application's URL.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}

\item{workerId}{Can generally be ignored. Exists to help some editions of
Shiny Server Pro route requests to the correct process.}

\item{quiet}{Should Shiny status messages be shown? Defaults to FALSE.}

\item{display.mode}{The mode in which to display the application. If set to
the value \code{"showcase"}, shows application code and metadata from a
\code{DESCRIPTION} file in the application directory alongside the
application. If set to \code{"normal"}, displays the application normally.
Defaults to \code{"auto"}, which displays the application in the mode given
in its \code{DESCRIPTION} file, if any.}

\item{test.mode}{Should the application be launched in test mode? This is
only used for recording or running automated tests. Defaults to the
\code{shiny.testmode} option, or FALSE if the option is not set.}
}
\value{
See \code{?shiny::shinyApp} and \code{?shiny::runApp}
}
\description{
These works just like \code{shiny::shinyApp} and \code{shiny::runApp} and have the exact same parameters,
except they create/run a modified app that allows for easier debugging.
}
\details{
For this function to work properly the main server function should always be
assigned to an object (usually you'd name it \code{server}).

For instance :
\itemize{
\item if you have a \code{server.R} script, make sure to assign your function to \code{server}
\item if you use \code{shinyServer}, create a \code{server} function separately and use it
in your \code{shinyServer} call.
}

It also assumes you follow standard practice in your use of \code{callModule()} or
\code{moduleServer()}.
}
