% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historical_weather.R
\name{get_historical_weather}
\alias{get_historical_weather}
\alias{get_historical}
\title{Obtain historical BOM data}
\usage{
get_historical_weather(
  stationid = NULL,
  latlon = NULL,
  radius = NULL,
  type = c("rain", "min", "max", "solar")
)

get_historical(
  stationid = NULL,
  latlon = NULL,
  radius = NULL,
  type = c("rain", "min", "max", "solar")
)
}
\arguments{
\item{stationid}{\acronym{BOM} station \sQuote{ID}. See Details.}

\item{latlon}{Length-2 numeric vector of Latitude/Longitude. See Details.}

\item{radius}{Numeric value, distance (km) from \var{latlon}, must be
numeric.}

\item{type}{Measurement type for \code{daily}, either daily \dQuote{rain},
\dQuote{min} (temp), \dQuote{max} (temp), or \dQuote{solar} (exposure).
Partial matching is performed. If not specified returns the first
matching type in the order listed. Ignored if \code{hourly} or
\code{minute} are selected for \code{tscale}.}
}
\value{
A \code{bomrang_tbl} object (extension of a
\code{\link[base]{data.frame}}) of historical observations for the selected
station/product type, with some subset of the following columns:

\tabular{rl}{
\strong{Product_code}:\tab BOM internal code.\cr
\strong{Station_number}:\tab BOM station ID.\cr
\strong{Year}:\tab Year of observation (YYYY).\cr
\strong{Month}:\tab Month of observation (1-12).\cr
\strong{Day}:\tab Day of observation (1-31).\cr
\strong{Min_temperature}:\tab Minimum daily recorded temperature (degrees C).\cr
\strong{Max_temperature}:\tab Maximum daily recorded temperature (degrees C).\cr
\strong{Accum_days_min}:\tab Accumulated number of days of minimum
temperature.\cr
\strong{Accum_days_max}:\tab Accumulated number of days of maximum
temperature.\cr
\strong{Rainfall}:\tab Daily recorded rainfall in mm.\cr
\strong{Period}:\tab Period over which rainfall was measured.\cr
\strong{Solar_exposure}:\tab Daily global solar exposure in MJ/m^2.\cr
\strong{Quality}:\tab Y, N, or missing. Data which have not yet completed the\cr
\tab routine quality control process are marked accordingly.
}

The following attributes are set on the data, and these are used to
generate the header:

\tabular{rl}{
\strong{site}:\tab BOM station ID.\cr
\strong{name}:\tab BOM station name.\cr
\strong{lat}:\tab Latitude in decimal degrees.\cr
\strong{lon}:\tab Longitude in decimal degrees.\cr
\strong{start}:\tab Date observations start.\cr
\strong{end}:\tab Date observations end.\cr
\strong{years}:\tab Available number of years data.\cr
\strong{percent}:\tab Percent complete.\cr
\strong{AWS}:\tab Automated weather station?\cr
\strong{type}:\tab Measurement types available for the station.\cr
}
}
\description{
Retrieves daily observations for a given station.
}
\note{
Methods \code{get_historical_weather} and \code{get_historical} are
equivalent. No preference is given to the use of either.
}
\section{Caution}{

Temperature data prior to 1910 should be used with extreme caution as many
stations prior to that date were exposed in non-standard shelters. Some
of which give readings which are several degrees warmer or cooler than
those measured according to post-1910 standards.

Daily maximum temperatures usually occur in the afternoon and daily minimum
temperatures overnight or near dawn. Occasionally, however, the lowest
temperature in the 24 hours to prior to 9 AM can occur around 9 AM the
previous day if the night was particularly warm.

Either \code{stationid} or \code{latlon} must be provided, but if both are,
then \code{stationid} will be used as it is more reliable.

In some cases data is available back to the 1800s, so tens-of-thousands of
daily records will be returned. Other stations will be newer and will
return fewer observations.
}

\section{\CRANpkg{dplyr} Compatibility}{
 The \code{bomrang_tbl} class is
compatible with \code{\link[dplyr:dplyr-package]{dplyr}} as long as the
\code{bomrang} package is on the search path. Common functions
(\code{\link[dplyr]{filter}}, \code{\link[dplyr]{select}},
\code{\link[dplyr]{arrange}}, \code{\link[dplyr]{mutate}},
\code{\link[dplyr:select]{rename}}, \code{\link[dplyr]{arrange}},
\code{\link[dplyr]{slice}}, \code{\link[dplyr]{group_by}}) are provided
which mask the \CRANpkg{dplyr} versions (but use those internally,
maintaining attributes).
}

\examples{
\donttest{
get_historical_weather(stationid = "023000",
                      type = "max") ## ~48,000+ daily records
get_historical_weather(latlon = c(-35.2809, 149.1300),
                       type = "min") ## 3,500+ daily records
}
\donttest{
get_historical(stationid = "023000",
              type = "max") ## ~48,000+ daily records
get_historical(latlon = c(-35.2809, 149.1300),
               type = "min") ## 3,500+ daily records
}
}
\seealso{
\link{get_current_weather}
}
\author{
Jonathan Carroll, \email{rpkg@jcarroll.com.au}
}
