% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeries.R
\name{get_timeseries}
\alias{get_timeseries}
\title{Get time series}
\usage{
get_timeseries(
  parameter_type,
  station_number,
  start_date,
  end_date,
  tz,
  return_fields,
  ts_name
)
}
\arguments{
\item{parameter_type}{The water data parameter type (e.g. Water Course
Discharge). See \code{\link{parameters()}} for a full list.}

\item{station_number}{The AWRC station number.}

\item{start_date}{Start date formatted as a string or date class
(YYYY-MM-DD).}

\item{end_date}{End date formatted as a string or date class (YYYY-MM-DD).}

\item{tz}{Optional: the desired time zone for the output timeseries. Input
must be an Olson Name (see `OlsonNames()`). By default the the timeseries
is returned in an offset timezone (e.g. `Etc/GMT-10` for NSW) as the
timeseries do not observe DST.}

\item{return_fields}{Optional: columns to be returned from Water Data Online.
By default Timestamp, Value and Quality Code are returned.}

\item{ts_name}{The timeseries name (e.g. DMQaQc.Merged.DailyMean.24HR) that
is desired.}
}
\value{
A tibble with columns with the requested return_fields. A zero row tibble is
returned if no data is returned  from the query. The columns of the tibble
are returned as character classes and have not been formatted to more
appropriate correct classes (this happens in other functions).
}
\description{
`get_timeseries` Get timeseries data from Water Data online
}
\details{
This function can be used if you want to retrieve a specific
timeseries that is not the default quality checked one.
}
\examples{
# Accessible dam storage, as shown on the BoM Water Storage dashboard
get_timeseries(
  parameter_type = "Storage Volume",
  "G8150011",
  "2020-01-01",
  "2020-01-31",
  ts_name = "PR02AVQaQc.Merged.DailyMean.24HR",
  tz = NULL,
  return_fields = c("Timestamp", "Value", "Quality Code", "Interpolation Type")
)
# See the linked SOS2 manual in See Also to find more timeseries names
}
\seealso{
* \url{http://www.bom.gov.au/waterdata/}
* \url{http://www.bom.gov.au/waterdata/wiski-web-public/Guide\%20to\%20Sensor\%20Observation\%20Services\%20(SOS2)\%20for\%20Water\%20Data\%20\%20Online\%20v1.0.1.pdf}
}
\author{
Alexander Buzacott
}
