% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/io-methods.R
\docType{methods}
\name{write_xgmml}
\alias{write_xgmml}
\alias{write_xgmml,BN}
\alias{write_xgmml,BN-method}
\title{Write a network saving it in an \code{XGMML} file.}
\usage{
write_xgmml(x, path = "./network", write.wpdag = FALSE,
  node.col = rep("white", num.nodes(x)), frac = 0.2,
  max.weight = max(wpdag(x)))

\S4method{write_xgmml}{BN}(x, path = "./network", write.wpdag = FALSE,
  node.col = rep("white", num.nodes(x)), frac = 0.2,
  max.weight = max(wpdag(x)))
}
\arguments{
\item{x}{the \code{\link{BN}} object.}

\item{path}{file name with relative or absolute path to be written.}

\item{write.wpdag}{write the weighted PDAG computed using bootstrap samples or the MMPC 
structure algorithm, instead of the normaldag (default FALSE).}

\item{node.col}{vector of colors for each node of the network (in R colornames).}

\item{frac}{minimum fraction [0,1] of presence of an edge to be plotted (used in case of \code{write.wpdag=TRUE}).}

\item{max.weight}{maximum possible weight of an edge (used in case of \code{write.wpdag=TRUE}).}
}
\description{
Write a network on disk, saving it in an \code{XGMML} file,
for importing it in Cytoscape.
}

