\name{bn class}
\alias{bn class}
\alias{bn-class}
\title{

  The bn class structure

}
\description{

  The structure of an object of S3 class \code{bn}.

}
\details{

  An object of class \code{bn} is a list containing at least the
  following components:

  \itemize{

    \item \code{learning}: a list containing some information about
       the results of the learning algorithm. It's never changed
       afterward.

    \itemize{

      \item \code{whitelist}: a sanitized copy of the \code{whitelist}
        parameter (a two-column matrix, whose columns are labeled
        \code{from} and \code{to}).

      \item \code{blacklist}: a sanitized copy of the \code{blacklist}
        parameter (a two-column matrix, whose columns are labeled
        \code{from} and \code{to}).

      \item \code{test}: the label of the conditional independence test
        used by the learning algorithm (a character string). The
        label of the network score is used for score-based and hybrid
        algorithms, and "none" for randomly generated graphs.

      \item \code{ntests}: the number of conditional independence tests
        or score comparisons used in the learning (an integer value).

      \item \code{algo}: the label of the learning algorithm or the
        random generation algorithm used to generate the network
        (a character string).

      \item \code{args}: a list. The values of the parameters of
        either the conditional tests or the scores used in the learning
        process. Only the relevant ones are stored, so this may be
        an empty list.

        \itemize{

          \item \code{alpha}: the target nominal type I error rate (a
            numeric value) of the conditional independence tests.

          \item \code{iss}: a positive numeric value, the imaginary
            sample size used by the \code{bge} and \code{bde} scores.

          \item \code{phi}: a character string, either \code{heckerman}
            or \code{bottcher}; used by the \code{bge} score.

          \item \code{k}: a positive numeric value, the penalty per
            parameter used by the \code{aic}, \code{aic-g}, \code{bic}
            and \code{bic-g} scores.

          \item \code{prob}: the probability of each arc to be present in
            a graph generated by the \code{ordered} graph generation algorithm.

          \item \code{burn.in}: the number of iterations for the \code{ic-dag}
            graph generation algorithm to converge to a stationary (and uniform)
            probability distribution.

          \item \code{max.degree}: the maximum degree for any node in a graph
            generated by the \code{ic-dag} graph generation algorithm.

           \item \code{max.in.degree}: the maximum in-degree for any node in
             a graph generated by the \code{ic-dag} graph generation algorithm.

           \item \code{max.out.degree}: the maximum out-degree for any node in
             a graph generated by the \code{ic-dag} graph generation algorithm.

           \item \code{training}: a character string, the label of the training
             node in a Bayesian network classifier.

           \item \code{threshold}: the threshold used to determine which arcs 
             are significant when averaging network structures.

        }

    }

    \item \code{nodes}: a list. Each element is named after a node
        and contains the following elements:

    \itemize{

      \item \code{mb}: the Markov blanket of the node (a vector of
        character strings).

      \item \code{nbr}: the neighbourhood of the node (a vector of
        character strings).

      \item \code{parents}: the parents of the node (a vector of
        character strings).

      \item \code{children}: the children of the node (a vector of
        character strings).

    }

    \item \code{arcs}: the arcs of the Bayesian network (a two-column
      matrix, whose columns are labeled \code{from} and \code{to}).
      Undirected arcs are stored as two directed arcs with opposite
      directions between the corresponding incident nodes.

  }

  Additional (optional) components under \code{learning}:

  \itemize{

    \item \code{optimized}: whether additional optimizations have been used in
      the learning algorithm (a boolean value).

    \item \code{restrict}: the label of the constraint-based algorithm used in
      the \dQuote{Restrict} phase of a hybrid learning algorithm (a character
      string).

    \item \code{rtest}: the label of the conditional independence test used in
      the \dQuote{Restrict} phase of a hybrid learning algorithm (a character
      string).

    \item \code{maximize}: the label of the score-based algorithm used in the
      \dQuote{Maximize} phase of a hybrid learning algorithm (a character
      string).

    \item \code{maxscore}: the label of the network score used in the
      \dQuote{Maximize} phase of a hybrid learning algorithm (a character
      string).

  }

}
\author{ Marco Scutari }
\keyword{ classes }
