% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/anb-dag.R, R/wrap-gRain.R
\name{grain_and_graph}
\alias{as_grain}
\alias{as_graphNEL}
\alias{grain_and_graph}
\title{Convert to graph and gRain.}
\usage{
as_graphNEL(x)

as_grain(x)
}
\arguments{
\item{x}{The \code{\link{bnc_bn}} object. The Bayesian network classifier.}
}
\description{
Convert a \code{\link{bnc_dag}} to \code{\link[graph]{graphNEL}} and
\code{\link[gRain]{grain}} objects.
}
\section{Functions}{
\itemize{
\item \code{as_graphNEL}: Convert to a graphNEL.

\item \code{as_grain}: Convert to a grain.
}}
\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
g <- as_grain(nb)
gRain::querygrain.grain(g)$buying
}

